/**
 * OWASP AppSensor
 * 
 * This file is part of the Open Web Application Security Project (OWASP)
 * AppSensor project. For details, please see
 * <a href="http://www.owasp.org/index.php/Category:OWASP_AppSensor_Project">
 * 	http://www.owasp.org/index.php/Category:OWASP_AppSensor_Project</a>.
 *
 * Copyright (c) 2010 - The OWASP Foundation
 * 
 * AppSensor is published by OWASP under the BSD license. You should read and accept the
 * LICENSE before you use, modify, and/or redistribute this software.
 * 
 * @author Michael Coates <a href="http://www.aspectsecurity.com">Aspect Security</a>
 * @author John Melton <a href="http://www.jtmelton.com/">jtmelton</a>
 * @created 2010
 */
namespace org.owasp.appsensor.reference.adapters
{
    using System;
    using System.Security.Principal;
    using System.Web.Security;
    using org.owasp.appsensor;
    using Owasp.Esapi;

    /**
     * This is a simple adapter class.  All it does is implement the ASUser interface
     * and call through to get the current user from Esapi in order to pass through
     * the method requests.
     * 
     * @author Michael Coates (michael.coates .at. owasp.org) 
     *         <a href="http://www.aspectsecurity.com">Aspect Security</a>
     * @author John Melton (jtmelton .at. gmail.com)
     *         <a href="http://www.jtmelton.com/">jtmelton</a>
     * @since May 6, 2010
     */
    public class ESAPIASCurrentUser : ASUser
    {
        /**
         * {@inheritDoc}
         */
        public long AccountId
        {
            get
            {
                return Esapi.Authenticator.CurrentUser.AccountId;
            }
        }

        /**
         * {@inheritDoc}
         */
        public String AccountName
        {
            get
            {
                return Esapi.Authenticator.CurrentUser.AccountName;
            }
        }

        /**
         * {@inheritDoc}
         */
        public bool Anonymous
        {
            get
            {
                return Esapi.Authenticator.CurrentUser.Anonymous;
            }
        }

        /**
         * {@inheritDoc}
         */
        public void Disable()
        {
            Esapi.Authenticator.CurrentUser.Disable();
        }

        /**
         * {@inheritDoc}
         */
        public void Logout()
        {
            Esapi.Authenticator.CurrentUser.Logout();
        }

        /**
         * {@inheritDoc}
         */
        public bool Enabled
        {
            get
            {
                return Esapi.Authenticator.CurrentUser.Enabled;
            }
        }
    }
}